-- Look README.md for see the reserved action/unique numbers

TileAction = {
	-- Cure poison tiles at dawnport outpost entrances
	-- Tiles data\scripts\movements\others\dawnport_tiles.lua
	[20001] = {
		itemId = 416,
		itemPos = {
			{x = 32064, y = 31881, z = 5},
			{x = 32065, y = 31881, z = 5},
			{x = 32074, y = 31890, z = 5},
			{x = 32074, y = 31891, z = 5},
			{x = 32064, y = 31900, z = 5},
			{x = 32065, y = 31900, z = 5},
			{x = 32056, y = 31890, z = 5},
			{x = 32056, y = 31891, z = 5}
		}
	},
	-- Dark trails quest tile
	-- data\scripts\movements\quests\dark_trails\necrometer_tile_access.lua
	[25001] = {
		itemId = false,
		itemPos = {
			{x = 33418, y = 32108, z = 10},
			{x = 33419, y = 32108, z = 10}
		}
	},
	-- First dragon quest tile
	-- data\scripts\movements\quests\first_dragon\zorvorax_secrets.lua
	[25002] = {
		itemId = false,
		itemPos = {
			{x = 33135, y = 32652, z = 7},
			{x = 33128, y = 32654, z = 7}
		}
	},
	[25003] = {
		itemId = false,
		itemPos = {
			{x = 32348, y = 31691, z = 7},
			{x = 32343, y = 31694, z = 7}
		}
	},
	[25004] = {
		itemId = false,
		itemPos = {
			{x = 32696, y = 31720, z = 7},
			{x = 32697, y = 31720, z = 7},
			{x = 32698, y = 31720, z = 7}
		}
	},
	--Dawnport
	--Sorcerer vocation tile
	--Vocation trial: data\scripts\movements\others\dawnport_vocation_trial.lua
	[25005] = {
		itemId = 416,
		itemPos = {
			{x = 32055, y = 31889, z = 5},
			{x = 32055, y = 31890, z = 5},
			{x = 32055, y = 31891, z = 5},
			{x = 32055, y = 31892, z = 5}
		}
	},
	--Druid vocation tile
	[25006] = {
		itemId = 416,
		itemPos = {
			{x = 32063, y = 31901, z = 5},
			{x = 32064, y = 31901, z = 5},
			{x = 32065, y = 31901, z = 5},
			{x = 32066, y = 31901, z = 5}
		}
	},
	--Paladin vocation tile
	[25007] = {
		itemId = 416,
		itemPos = {
			{x = 32075, y = 31889, z = 5},
			{x = 32075, y = 31890, z = 5},
			{x = 32075, y = 31891, z = 5},
			{x = 32075, y = 31892, z = 5},
		}
	},
	--Knight vocation tile
	[25008] = {
		itemId = 416,
		itemPos = {
			{x = 32063, y = 31880, z = 5},
			{x = 32064, y = 31880, z = 5},
			{x = 32065, y = 31880, z = 5},
			{x = 32066, y = 31880, z = 5}
		}
	},
	-- Tiles data\scripts\movements\others\dawnport_tiles.lua
	--Stairs decided vocation back
	[25009] = {
		itemId = 1947,
		itemPos = {
			{x = 32063, y = 31889, z = 6},
			{x = 32064, y = 31889, z = 6},
			{x = 32065, y = 31889, z = 6},
			{x = 32066, y = 31889, z = 6}
		}
	},
	--Sorcerer door tile
	[25010] = {
		itemId = 409,
		itemPos = {
			{x = 32053, y = 31884, z = 6},
			{x = 32054, y = 31884, z = 6},
			{x = 32055, y = 31884, z = 6}
		}
	},
	--Druid door tile
	[25011] = {
		itemId = 409,
		itemPos = {
			{x = 32072, y = 31884, z = 6},
			{x = 32073, y = 31884, z = 6},
			{x = 32074, y = 31884, z = 6}
		}
	},
	--Paladin door tile
	[25012] = {
		itemId = 409,
		itemPos = {
			{x = 32058, y = 31884, z = 6},
			{x = 32059, y = 31884, z = 6},
			{x = 32060, y = 31884, z = 6}
		}
	},
	--Knight door tile
	[25013] = {
		itemId = 409,
		itemPos = {
			{x = 32067, y = 31884, z = 6},
			{x = 32068, y = 31884, z = 6},
			{x = 32069, y = 31884, z = 6}
		}
	},
	--Sorcerer chest tile
	[25014] = {
		itemId = 409,
		itemPos = {{x = 32054, y = 31880, z = 6}}
	},
	--Druid chest tile
	[25015] = {
		itemId = 409,
		itemPos = {{x = 32073, y = 31880, z = 6}}
	},
	--Paladin chest tile
	[25016] = {
		itemId = 409,
		itemPos = {{x = 32059, y = 31880, z = 6}}
	},
	--Knight chest tile
	[25017] = {
		itemId = 409,
		itemPos = {{x = 32068, y = 31880, z = 6}}
	},
	-- The cursed crystal medusa message
	[25018] = {
		itemId = 104,
		itemPos = {
			{x = 32017, y = 32917, z = 10},
			{x = 32017, y = 32918, z = 10}
		}
	},
	-- The queen of the banshees quest
	-- Path: data\scripts\movements\quests\the_queen_of_the_banshees\movement(1)-first_seal_teleport_back.lua
	[25019] = {
		itemId = 353,
		itemPos = {
			{x = 32265, y = 31898, z = 12},
			{x = 32266, y = 31898, z = 12},
			{x = 32267, y = 31898, z = 12}
		}
	},
	-- Path: data\scripts\movements\quests\the_queen_of_the_banshees\movement(5)-fifth_seal_path.lua
	[25020] = {
		itemId = 431,
		itemPos = {
			{x = 32187, y = 31937, z = 14},
			{x = 32188, y = 31937, z = 14},
			{x = 32188, y = 31938, z = 14},
			{x = 32189, y = 31938, z = 14},
			{x = 32189, y = 31939, z = 14},
			{x = 32189, y = 31940, z = 14},
			{x = 32190, y = 31940, z = 14},
			{x = 32191, y = 31939, z = 14},
			{x = 32191, y = 31938, z = 14}
		}
	},
	-- Path: data\scripts\movements\quests\the_queen_of_the_banshees\movement(5)-fifth_seal_path.lua
	[25021] = {
		itemId = 431,
		itemPos = {
			{x = 32187, y = 31936, z = 14},
			{x = 32188, y = 31936, z = 14},
			{x = 32189, y = 31936, z = 14},
			{x = 32190, y = 31936, z = 14},
			{x = 32191, y = 31936, z = 14},
			{x = 32189, y = 31937, z = 14},
			{x = 32190, y = 31937, z = 14},
			{x = 32191, y = 31937, z = 14},
			{x = 32187, y = 31938, z = 14},
			{x = 32190, y = 31938, z = 14},
			{x = 32187, y = 31939, z = 14},
			{x = 32188, y = 31939, z = 14},
			{x = 32190, y = 31939, z = 14},
			{x = 32187, y = 31940, z = 14},
			{x = 32188, y = 31940, z = 14},
			{x = 32189, y = 31940, z = 14},
			{x = 32191, y = 31940, z = 14}
		}
	},
	-- Path: data\scripts\movements\quests\the_queen_of_the_banshees\movement(4)-fourth_seal_sacrifice.lua
	[25022] = {
		itemId = 430,
		itemPos = {{x = 32243, y = 31892, z = 14}}
	},
	-- Path: data\scripts\movements\quests\the_queen_of_the_banshees\movement(3)-third_seal_warlock_tile.lua
	[25023] = {
		itemId = 431,
		itemPos = {
			{x = 32215, y = 31838, z = 15},
			{x = 32216, y = 31838, z = 15}
		}
	},
	-- Threatened Dreams Quest
	[25024] = {
		itemId = false,
		itemPos = {
			{x = 33200, y = 31892, z = 7},
			{x = 33201, y = 31892, z = 7},
			{x = 33201, y = 31893, z = 7},
			{x = 33201, y = 31894, z = 7}
		}
	},
	[25025] = {
		itemId = false,
		itemPos = {
			{x = 33265, y = 32422, z = 7},
			{x = 33265, y = 32423, z = 7},
			{x = 33266, y = 32423, z = 7},
			{x = 33267, y = 32423, z = 7}
		}
	},
	[25026] = {
		itemId = false,
		itemPos = {
			{x = 33262, y = 32378, z = 7},
			{x = 33262, y = 32377, z = 7},
			{x = 33263, y = 32377, z = 7},
			{x = 33264, y = 32377, z = 7},
			{x = 33262, y = 32379, z = 7},
			{x = 33263, y = 32379, z = 7},
			{x = 33264, y = 32379, z = 7}
		}
	},
	[25027] = {
		itemId = false,
		itemPos = {
			{x = 33257, y = 32315, z = 7},
			{x = 33257, y = 32314, z = 7},
			{x = 33259, y = 32314, z = 7},
			{x = 33259, y = 32315, z = 7}
		}
	},
	[25028] = {
		itemId = false,
		itemPos = {
			{x = 33249, y = 32267, z = 6},
			{x = 33249, y = 32268, z = 6},
			{x = 33250, y = 32268, z = 6}
		}
	},
	[25029] = {
		itemId = 10840,
		itemPos = {
			{x = 33619, y = 32304, z = 9},
			{x = 33591, y = 32321, z = 10}
		}
	},
	-- Others actions
	-- Kilmaresh
	-- First mission
	[50307] = {
		itemId = false,
		itemPos = {
			{ x = 33956, y = 31503, z = 2 },
			{ x = 33957, y = 31503, z = 2 }
		}
	},
	-- The paradox tower quest
	-- data\scripts\movements\quests\the_paradox_tower\movement-last_floor_reward.lua
	-- Phoenix egg
	[50308] = {
		itemId = 431,
		itemPos = {
			{x = 32476, y = 31903, z = 1},
			{x = 32477, y = 31903, z = 1},
			{x = 32478, y = 31903, z = 1}
		}
	},
	-- 10000 gold coins
	[50309] = {
		itemId = 431,
		itemPos = {
			{x = 32479, y = 31903, z = 1},
			{x = 32481, y = 31902, z = 1},
			{x = 32476, y = 31902, z = 1}
		}
	},
		-- Talons
	[50310] = {
		itemId = 431,
		itemPos = {
			{x = 32478, y = 31902, z = 1},
			{x = 32479, y = 31902, z = 1},
			{x = 32480, y = 31902, z = 1}
		}
	},
	-- Wand of cosmic energy
	[50311] = {
		itemId = 431,
		itemPos = {
			{x = 32477, y = 31902, z = 1},
			{x = 32480, y = 31903, z = 1},
			{x = 32481, y = 31903, z = 1}
		}
	},
	-- The Rookie Guard Quest - Mission 02: Defence!
	-- Path: data\scripts\actions\quests\the_rookie_guard\mission02_defense.lua
	-- North exit
	[50312] = {
		itemId = false,
		itemPos = {
			{x = 32087, y = 32181, z = 7},
			{x = 32088, y = 32181, z = 7},
			{x = 32089, y = 32181, z = 7},
			{x = 32090, y = 32181, z = 7},
			{x = 32091, y = 32181, z = 7},
			{x = 32092, y = 32181, z = 7},
			{x = 32093, y = 32181, z = 7},
			{x = 32094, y = 32181, z = 7},
		}
	},
	-- Barn entrance
	[50313] = {
		itemId = false,
		itemPos = {
			{x = 32081, y = 32190, z = 7},
			{x = 32082, y = 32190, z = 7},
			{x = 32083, y = 32190, z = 7},
			{x = 32084, y = 32189, z = 7}
		}
	},
	-- Bar entrance
	[50314] = {
		itemId = false,
		itemPos = {
			{x = 32095, y = 32182, z = 7},
			{x = 32095, y = 32183, z = 7},
			{x = 32095, y = 32184, z = 7},
			{x = 32095, y = 32185, z = 7}
		}
	},
	-- Academy center
	[50315] = {
		itemId = 8230,
		itemPos = {
			{x = 32096, y = 32194, z = 7},
			{x = 32097, y = 32194, z = 7},
			{x = 32098, y = 32194, z = 7}
		}
	},
	-- Obi shop entrance
	[50316] = {
		itemId = 870,
		itemPos = {
			{x = 32101, y = 32204, z = 7},
			{x = 32101, y = 32205, z = 7},
			{x = 32101, y = 32206, z = 7}
		}
	},
	-- Center north road
	[50317] = {
		itemId = false,
		itemPos = {
			{x = 32089, y = 32197, z = 7},
			{x = 32090, y = 32197, z = 7},
			{x = 32091, y = 32197, z = 7},
			{x = 32092, y = 32197, z = 7},
			{x = 32093, y = 32197, z = 7}
		}
	},
	-- Center north-west road
	[50318] = {
		itemId = false,
		itemPos = {
			{x = 32086, y = 32189, z = 7},
			{x = 32086, y = 32190, z = 7},
			{x = 32086, y = 32191, z = 7},
			{x = 32086, y = 32192, z = 7},
			{x = 32086, y = 32193, z = 7},
			{x = 32086, y = 32194, z = 7},
			{x = 32086, y = 32195, z = 7}
		}
	},
	-- North bridge exit
	[50319] = {
		itemId = 870,
		itemPos = {{x = 32091, y = 32169, z = 7}}
	},
	-- Outer north-west path
	[50320] = {
		itemId = false,
		itemPos = {
			{x = 32084, y = 32161, z = 7},
			{x = 32085, y = 32161, z = 7},
			{x = 32086, y = 32161, z = 7},
			{x = 32087, y = 32161, z = 7}
		}
	},
	-- Outer north-east path
	[50321] = {
		itemId = false,
		itemPos = {
			{x = 32097, y = 32161, z = 7},
			{x = 32098, y = 32161, z = 7},
			{x = 32099, y = 32161, z = 7},
			{x = 32100, y = 32161, z = 7},
			{x = 32105, y = 32161, z = 7},
			{x = 32106, y = 32161, z = 7},
			{x = 32107, y = 32161, z = 7},
			{x = 32109, y = 32161, z = 7},
			{x = 32110, y = 32161, z = 7},
			{x = 32111, y = 32161, z = 7},
			{x = 32112, y = 32161, z = 7},
			{x = 32113, y = 32161, z = 7},
			{x = 32114, y = 32161, z = 7},
			{x = 32115, y = 32161, z = 7},
			{x = 32116, y = 32161, z = 7},
			{x = 32117, y = 32161, z = 7},
			{x = 32120, y = 32161, z = 7},
			{x = 32122, y = 32161, z = 7},
			{x = 32124, y = 32161, z = 7},
			{x = 32125, y = 32161, z = 7}
		}
	},
	-- Outer south path
	[50322] = {
		itemId = false,
		itemPos = {
			{x = 32104, y = 32181, z = 7},
			{x = 32105, y = 32181, z = 7},
			{x = 32106, y = 32181, z = 7},
			{x = 32107, y = 32181, z = 7},
			{x = 32108, y = 32181, z = 7},
			{x = 32109, y = 32181, z = 7},
			{x = 32110, y = 32181, z = 7},
			{x = 32111, y = 32181, z = 7},
			{x = 32112, y = 32181, z = 7},
			{x = 32113, y = 32181, z = 7},
			{x = 32114, y = 32181, z = 7},
			{x = 32115, y = 32181, z = 7},
			{x = 32116, y = 32181, z = 7},
			{x = 32117, y = 32181, z = 7},
			{x = 32118, y = 32181, z = 7},
			{x = 32119, y = 32181, z = 7},
			{x = 32120, y = 32181, z = 7},
			{x = 32121, y = 32181, z = 7},
			{x = 32122, y = 32181, z = 7},
			{x = 32123, y = 32181, z = 7},
			{x = 32125, y = 32181, z = 7},
			{x = 32126, y = 32181, z = 7},
			{x = 32128, y = 32181, z = 7},
			{x = 32129, y = 32181, z = 7},
			{x = 32130, y = 32181, z = 7},
			{x = 32131, y = 32181, z = 7},
			{x = 32132, y = 32181, z = 7},
			{x = 32134, y = 32181, z = 7},
			{x = 32135, y = 32181, z = 7},
			{x = 32136, y = 32181, z = 7},
			{x = 32137, y = 32181, z = 7}
		}
	},
	-- Outer east path limit
	[50323] = {
		itemId = false,
		itemPos = {
			{x = 32096, y = 32162, z = 7},
			{x = 32096, y = 32163, z = 7},
			{x = 32096, y = 32164, z = 7},
			{x = 32096, y = 32165, z = 7},
			{x = 32096, y = 32166, z = 7},
			{x = 32096, y = 32167, z = 7},
			{x = 32096, y = 32168, z = 7},
			{x = 32096, y = 32169, z = 7},
			{x = 32096, y = 32170, z = 7},
			{x = 32096, y = 32171, z = 7},
			{x = 32096, y = 32172, z = 7},
			{x = 32096, y = 32173, z = 7},
			{x = 32096, y = 32174, z = 7}
		}
	},
	-- Outer north troll cave limit
	[50324] = {
		itemId = false,
		itemPos = {
			{x = 32090, y = 32143, z = 7},
			{x = 32091, y = 32143, z = 7},
			{x = 32092, y = 32143, z = 7},
			{x = 32093, y = 32143, z = 7},
			{x = 32094, y = 32143, z = 7},
			{x = 32095, y = 32143, z = 7},
			{x = 32096, y = 32143, z = 7},
			{x = 32096, y = 32144, z = 7},
			{x = 32096, y = 32145, z = 7}
		}
	},
	-- North-west drawbridge limit
	[50325] = {
		itemId = false,
		itemPos = {
			{x = 32070, y = 32147, z = 6},
			{x = 32070, y = 32148, z = 6}
		}
	},
	-- North-west drawbridge, north exit limit
	[50326] = {
		itemId = false,
		itemPos = {
			{x = 32066, y = 32136, z = 7},
			{x = 32067, y = 32136, z = 7},
			{x = 32068, y = 32136, z = 7},
			{x = 32066, y = 32137, z = 7},
			{x = 32068, y = 32137, z = 7}
		}
	},
	-- Spider lair entrance
	[50327] = {
		itemId = false,
		itemPos = {
			{x = 32052, y = 32110, z = 7},
			{x = 32053, y = 32110, z = 7},
			{x = 32054, y = 32110, z = 7},
			{x = 32056, y = 32110, z = 7},
			{x = 32057, y = 32110, z = 7},
			{x = 32058, y = 32110, z = 7},
			{x = 32059, y = 32110, z = 7},
			{x = 32061, y = 32110, z = 7},
			{x = 32062, y = 32110, z = 7},
			{x = 32063, y = 32110, z = 7},
			{x = 32064, y = 32110, z = 7},
			{x = 32065, y = 32110, z = 7},
			{x = 32066, y = 32110, z = 7},
			{x = 32067, y = 32110, z = 7},
			{x = 32068, y = 32110, z = 7},
			{x = 32069, y = 32110, z = 7}
		}
	},
	-- Spider lair 3nd floor
	[50328] = {
		itemId = false,
		itemPos = {
			{x = 32001,  y = 32108, z = 11},
			{x = 32002,  y = 32108, z = 11},
			{x = 32003,  y = 32108, z = 11}
		}
	},
	-- Wolf forest path
	[50329] = {
		itemId = false,
		itemPos = {
			{x = 32107, y = 32167, z = 7},
			{x = 32107, y = 32168, z = 7},
			{x = 32107, y = 32169, z = 7},
			{x = 32107, y = 32170, z = 7}
		}
	},
	-- Wolf forest north limit
	[50330] = {
		itemId = false,
		itemPos = {
			{x = 32105, y = 32149, z = 7},
			{x = 32106, y = 32149, z = 7},
			{x = 32107, y = 32149, z = 7},
			{x = 32108, y = 32149, z = 7},
			{x = 32109, y = 32149, z = 7},
			{x = 32110, y = 32149, z = 7},
			{x = 32111, y = 32149, z = 7},
			{x = 32112, y = 32149, z = 7},
			{x = 32113, y = 32149, z = 7},
			{x = 32114, y = 32149, z = 7},
			{x = 32115, y = 32149, z = 7},
			{x = 32116, y = 32149, z = 7},
			{x = 32117, y = 32149, z = 7},
			{x = 32118, y = 32149, z = 7},
			{x = 32119, y = 32149, z = 7}
		}
	},
	-- Wolf forest north-east limit
	[50331] = {
		itemId = false,
		itemPos = {
			{x = 32120, y = 32133, z = 7},
			{x = 32120, y = 32134, z = 7},
			{x = 32120, y = 32135, z = 7},
			{x = 32120, y = 32136, z = 7},
			{x = 32120, y = 32137, z = 7},
			{x = 32120, y = 32138, z = 7},
			{x = 32120, y = 32139, z = 7},
			{x = 32120, y = 32140, z = 7},
			{x = 32120, y = 32141, z = 7},
			{x = 32120, y = 32142, z = 7},
			{x = 32120, y = 32143, z = 7},
			{x = 32120, y = 32144, z = 7},
			{x = 32120, y = 32145, z = 7},
			{x = 32120, y = 32146, z = 7},
			{x = 32120, y = 32147, z = 7}
		}
	},
	-- War wolf den entrance
	[50332] = {
		itemId = false,
		itemPos = {
			{x = 32134, y = 32136, z = 7},
			{x = 32136, y = 32136, z = 7},
			{x = 32138, y = 32136, z = 7},
			{x = 32139, y = 32136, z = 7},
			{x = 32140, y = 32136, z = 7},
			{x = 32141, y = 32136, z = 7},
			{x = 32142, y = 32136, z = 7},
			{x = 32143, y = 32136, z = 7},
			{x = 32144, y = 32136, z = 7}
		}
	},
	-- War wolf den first floor
	[50333] = {
		itemId = false,
		itemPos = {
			{x = 32133, y = 32136, z = 8},
			{x = 32134, y = 32136, z = 8},
			{x = 32135, y = 32136, z = 8},
			{x = 32133, y = 32137, z = 8},
			{x = 32135, y = 32137, z = 8},
			{x = 32133, y = 32138, z = 8},
			{x = 32134, y = 32138, z = 8},
			{x = 32135, y = 32138, z = 8}
		}
	},
	-- War wolf den boost floor
	[50334] = {
		itemId = false,
		itemPos = {
			{x = 32116, y = 32128, z = 11},
			{x = 32116, y = 32129, z = 11},
			{x = 32116, y = 32130, z = 11},
			{x = 32116, y = 32131, z = 11},
			{x = 32116, y = 32132, z = 11},
			{x = 32116, y = 32133, z = 11},
			{x = 32116, y = 32134, z = 11}
		}
	},
	-- Academy entrance
	[50335] = {
		itemId = 870,
		itemPos = {
			{x = 32096, y = 32200, z = 7},
			{x = 32097, y = 32200, z = 7},
			{x = 32098, y = 32200, z = 7}
		}
	},
	-- Academy low floor downstairs
	[50336] = {
		itemId = 417,
		itemPos = {{x = 32096,  y = 32191, z = 8}}
	},
	-- Academy library vault entrance
	[50337] = {
		itemId = 8230,
		itemPos = {
			{x = 32089, y = 32157, z = 9},
			{x = 32090, y = 32157, z = 9},
			{x = 32091, y = 32157, z = 9}
		}
	},
	-- Library vault downstairs
	[50338] = {
		itemId = 417,
		itemPos = {{x = 32089, y = 32154, z = 10}}
	},
	-- Library vault room floor
	[50339] = {
		itemId = 417,
		itemPos = {
			{x = 32085, y = 32139, z = 10},
			{x = 32086, y = 32139, z = 10},
			{x = 32087, y = 32139, z = 10},
			{x = 32088, y = 32139, z = 10},
			{x = 32089, y = 32139, z = 10},
			{x = 32090, y = 32139, z = 10},
			{x = 32091, y = 32139, z = 10},
			{x = 32085, y = 32140, z = 10},
			{x = 32086, y = 32140, z = 10},
			{x = 32087, y = 32140, z = 10},
			{x = 32088, y = 32140, z = 10},
			{x = 32089, y = 32140, z = 10},
			{x = 32090, y = 32140, z = 10},
			{x = 32091, y = 32140, z = 10},
			{x = 32084, y = 32141, z = 10},
			{x = 32085, y = 32141, z = 10},
			{x = 32086, y = 32141, z = 10},
			{x = 32087, y = 32141, z = 10},
			{x = 32088, y = 32141, z = 10},
			{x = 32089, y = 32141, z = 10},
			{x = 32091, y = 32141, z = 10},
			{x = 32092, y = 32141, z = 10},
			{x = 32082, y = 32142, z = 10},
			{x = 32083, y = 32142, z = 10},
			{x = 32084, y = 32142, z = 10},
			{x = 32092, y = 32142, z = 10},
			{x = 32093, y = 32142, z = 10},
			{x = 32094, y = 32142, z = 10},
			{x = 32080, y = 32143, z = 10},
			{x = 32081, y = 32143, z = 10},
			{x = 32084, y = 32143, z = 10},
			{x = 32085, y = 32143, z = 10},
			{x = 32086, y = 32143, z = 10},
			{x = 32087, y = 32143, z = 10},
			{x = 32088, y = 32143, z = 10},
			{x = 32089, y = 32143, z = 10},
			{x = 32090, y = 32143, z = 10},
			{x = 32091, y = 32143, z = 10},
			{x = 32092, y = 32143, z = 10},
			{x = 32093, y = 32143, z = 10},
			{x = 32094, y = 32143, z = 10},
			{x = 32095, y = 32143, z = 10},
			{x = 32096, y = 32143, z = 10},
			{x = 32080, y = 32144, z = 10},
			{x = 32081, y = 32144, z = 10},
			{x = 32082, y = 32144, z = 10},
			{x = 32083, y = 32144, z = 10},
			{x = 32084, y = 32144, z = 10},
			{x = 32085, y = 32144, z = 10},
			{x = 32090, y = 32144, z = 10},
			{x = 32091, y = 32144, z = 10},
			{x = 32092, y = 32144, z = 10},
			{x = 32093, y = 32144, z = 10},
			{x = 32094, y = 32144, z = 10},
			{x = 32095, y = 32144, z = 10},
			{x = 32096, y = 32144, z = 10},
			{x = 32090, y = 32145, z = 10},
			{x = 32091, y = 32145, z = 10},
			{x = 32080, y = 32146, z = 10},
			{x = 32081, y = 32146, z = 10},
			{x = 32082, y = 32146, z = 10},
			{x = 32083, y = 32146, z = 10},
			{x = 32084, y = 32146, z = 10},
			{x = 32085, y = 32146, z = 10},
			{x = 32086, y = 32146, z = 10},
			{x = 32087, y = 32146, z = 10},
			{x = 32088, y = 32146, z = 10},
			{x = 32089, y = 32146, z = 10},
			{x = 32090, y = 32146, z = 10},
			{x = 32091, y = 32146, z = 10},
			{x = 32092, y = 32146, z = 10},
			{x = 32093, y = 32146, z = 10},
			{x = 32094, y = 32146, z = 10},
			{x = 32095, y = 32146, z = 10},
			{x = 32096, y = 32146, z = 10},
			{x = 32081, y = 32147, z = 10},
			{x = 32082, y = 32147, z = 10},
			{x = 32083, y = 32147, z = 10},
			{x = 32084, y = 32147, z = 10},
			{x = 32085, y = 32147, z = 10},
			{x = 32086, y = 32147, z = 10},
			{x = 32087, y = 32147, z = 10},
			{x = 32088, y = 32147, z = 10},
			{x = 32089, y = 32147, z = 10},
			{x = 32090, y = 32147, z = 10},
			{x = 32091, y = 32147, z = 10},
			{x = 32092, y = 32147, z = 10},
			{x = 32093, y = 32147, z = 10},
			{x = 32094, y = 32147, z = 10},
			{x = 32095, y = 32147, z = 10},
			{x = 32096, y = 32147, z = 10},
			{x = 32081, y = 32148, z = 10},
			{x = 32082, y = 32148, z = 10},
			{x = 32083, y = 32148, z = 10},
			{x = 32084, y = 32148, z = 10},
			{x = 32092, y = 32148, z = 10},
			{x = 32093, y = 32148, z = 10},
			{x = 32094, y = 32148, z = 10},
			{x = 32095, y = 32148, z = 10},
			{x = 32096, y = 32148, z = 10},
			{x = 32083, y = 32149, z = 10},
			{x = 32084, y = 32149, z = 10},
			{x = 32085, y = 32149, z = 10},
			{x = 32086, y = 32149, z = 10},
			{x = 32087, y = 32149, z = 10},
			{x = 32088, y = 32149, z = 10},
			{x = 32089, y = 32149, z = 10},
			{x = 32090, y = 32149, z = 10},
			{x = 32091, y = 32149, z = 10},
			{x = 32092, y = 32149, z = 10},
			{x = 32093, y = 32149, z = 10},
			{x = 32085, y = 32150, z = 10},
			{x = 32086, y = 32150, z = 10},
			{x = 32087, y = 32150, z = 10},
			{x = 32088, y = 32150, z = 10},
			{x = 32089, y = 32150, z = 10},
			{x = 32090, y = 32150, z = 10},
			{x = 32091, y = 32150, z = 10},
			{x = 32087, y = 32151, z = 10},
			{x = 32088, y = 32151, z = 10},
			{x = 32089, y = 32151, z = 10},
			{x = 32090, y = 32151, z = 10},
			{x = 32091, y = 32151, z = 10},
			{x = 32087, y = 32152, z = 10},
			{x = 32088, y = 32152, z = 10},
			{x = 32089, y = 32152, z = 10},
			{x = 32090, y = 32152, z = 10},
			{x = 32091, y = 32152, z = 10},
			{x = 32086, y = 32153, z = 10},
			{x = 32087, y = 32153, z = 10},
			{x = 32088, y = 32153, z = 10},
			{x = 32090, y = 32153, z = 10},
			{x = 32091, y = 32153, z = 10},
			{x = 32086, y = 32154, z = 10},
			{x = 32087, y = 32154, z = 10},
			{x = 32088, y = 32154, z = 10},
			{x = 32090, y = 32154, z = 10},
			{x = 32091, y = 32154, z = 10}
		}
	},
	-- Academy library vault center
	[50340] = {
		itemId = 417,
		itemPos = {
			{x = 32085, y = 32145, z = 10},
			{x = 32090, y = 32145, z = 10},
			{x = 32091, y = 32145, z = 10}
		}
	},
	-- Academy library vault near rune
	[50341] = {
		itemId = 423,
		itemPos = {{x = 32083, y = 32143, z = 10}}
	},
	-- North-west drawbridge upstairs
	[50342] = {
		itemId = 4515,
		itemPos = {{x = 32088, y = 32147, z = 6}}
	},
	-- Troll caves entrance
	[50343] = {
		itemId = false,
		itemPos = {
			{x = 32094, y= 32140, z = 7},
			{x = 32095, y= 32140, z = 7},
			{x = 32096, y= 32140, z = 7},
			{x = 32097, y= 32140, z = 7},
			{x = 32098, y= 32140, z = 7},
			{x = 32099, y= 32140, z = 7}
		}
	},
	-- Troll caves dug tunnel downstair
	[50344] = {
		itemId = 352,
		itemPos = {{x = 32059, y = 32135, z = 10}}
	},
	-- Troll caves dug tunnel upstair
	[50345] = {
		itemId = 353,
		itemPos = {{x = 32059, y = 32136, z = 9}}
	},
	-- Outer east limit
	[50346] = {
		itemId = false,
		itemPos = {
			{x = 32128, y = 32174, z = 7},
			{x = 32128, y = 32176, z = 7},
			{x = 32128, y = 32177, z = 7},
			{x = 32128, y = 32178, z = 7},
			{x = 32128, y = 32179, z = 7},
			{x = 32128, y = 32180, z = 7},
			{x = 32128, y = 32181, z = 7},
			{x = 32128, y = 32184, z = 7},
			{x = 32128, y = 32185, z = 7},
			{x = 32128, y = 32186, z = 7},
			{x = 32128, y = 32187, z = 7},
			{x = 32128, y = 32188, z = 7},
			{x = 32128, y = 32189, z = 7},
			{x = 32128, y = 32191, z = 7},
			{x = 32128, y = 32193, z = 7},
			{x = 32128, y = 32194, z = 7},
			{x = 32128, y = 32196, z = 7},
			{x = 32128, y = 32197, z = 7},
			{x = 32128, y = 32198, z = 7},
			{x = 32129, y = 32198, z = 7}
		}
	},
	-- Unholy crypt entrance
	[50347] = {
		itemId = false,
		itemPos = {
			{x = 32129, y = 32201, z = 7},
			{x = 32129, y = 32202, z = 7},
			{x = 32131, y = 32204, z = 7},
			{x = 32132, y = 32204, z = 7}
		}
	},
	-- Unholy crypt door entrance
	[50348] = {
		itemId = 499,
		itemPos = {
			{x = 32146, y = 32187, z = 9},
			{x = 32147, y = 32187, z = 9}
		}
	},
	-- Unholy crypt near sarcophagus
	[50349] = {
		itemId = false,
		itemPos = {
			{x = 32140, y = 32202, z = 10},
			{x = 32140, y = 32203, z = 10}
		}
	},
	-- Near north-west drawbridge
	[50350] = {
		itemId = false,
		itemPos = {
			{x = 32091, y = 32147, z = 7},
			{x = 32092, y = 32147, z = 7},
			{x = 32093, y = 32147, z = 7},
			{x = 32094, y = 32147, z = 7}
		}
	},
	-- North-west drawbridge south downstairs
	[50351] = {
		itemId = 4515,
		itemPos = {{x = 32065, y = 32156, z = 7}}
	},
	-- Orc land entrance
	[50352] = {
		itemId = false,
		itemPos = {
			{x = 32002, y = 32152, z = 7},
			{x = 32003, y = 32152, z = 7},
			{x = 32004, y = 32152, z = 7},
			{x = 32005, y = 32152, z = 7}
		}
	},
	-- Wasp lair entrance
	[50353] = {
		itemId = 355,
		itemPos = {
			{x = 31999, y = 32142, z = 7},
			{x = 32000, y = 32142, z = 7}
		}
	},
	-- Academy downfloor trasure door entrance
	[50354] = {
		itemId = 417,
		itemPos = {
			{x = 32108, y = 32190, z = 8},
			{x = 32109, y = 32190, z = 8},
			{x = 32110, y = 32190, z = 8}
		}
	},
	-- Orc fortress peeing area
	[50355] = {
		itemId = 194,
		itemPos = {
			{x = 31968, y = 32148, z = 7},
			{x = 31969, y = 32148, z = 7}
		}
	},
	-- Orc fortress entrance
	[50356] = {
		itemId = 194,
		itemPos = {
			{x = 31986, y = 32158, z = 7},
			{x = 31986, y = 32159, z = 7}
		}
	},
	-- Orc fortress near elite orc guard
	[50357] = {
		itemId = 194,
		itemPos = {
			{x = 31976, y = 32151, z = 7},
			{x = 31978, y = 32151, z = 7},
			{x = 31976, y = 32152, z = 7},
			{x = 31978, y = 32152, z = 7},
			{x = 31972, y = 32152, z = 7},
			{x = 31973, y = 32152, z = 7},
			{x = 31974, y = 32152, z = 7},
			{x = 31975, y = 32152, z = 7},
			{x = 31976, y = 32152, z = 7},
			{x = 31978, y = 32152, z = 7},
			{x = 31979, y = 32152, z = 7},
			{x = 31980, y = 32152, z = 7},
			{x = 31981, y = 32152, z = 7},
			{x = 31982, y = 32152, z = 7}
		}
	},
	-- Orc fortress in front elite orc guard
	[50358] = {
		itemId = 194,
		itemPos = {
			{x = 31977, y = 32151, z = 7},
			{x = 31977, y = 32152, z = 7}
		}
	},
	-- Orc fortress interior
	[50359] = {
		itemId = 353,
		itemPos = {{x = 31977, y = 32149, z = 8}}
	},
	-- Orc fortress interior kitchen
	[50360] = {
		itemId = false,
		itemPos = {
			{x = 31981, y = 32157, z = 8},
			{x = 31981, y = 32158, z = 8},
			{x = 31981, y = 32159, z = 8},
			{x = 31981, y = 32160, z = 8},
			{x = 31982, y = 32160, z = 8},
			{x = 31983, y = 32160, z = 8},
			{x = 31984, y = 32160, z = 8},
			{x = 31985, y = 32160, z = 8},
			{x = 31986, y = 32160, z = 8},
			{x = 31987, y = 32160, z = 8},
			{x = 31988, y = 32160, z = 8}
		}
	},
	-- Orc fortress interior south path
	[50361] = {
		itemId = false,
		itemPos = {
			{x = 31978, y = 32173, z = 8},
			{x = 31979, y = 32173, z = 8}
		}
	},
	-- Orc fortress interior near south downstair
	[50362] = {
		itemId = 351,
		itemPos = {
			{x = 31978, y = 32178, z = 8},
			{x = 31979, y = 32178, z = 8}
		}
	},
	-- Kraknaknork lair near room teleport
	[50363] = {
		itemId = false,
		itemPos = {
			{x = 31951, y = 32173, z = 10},
			{x = 31951, y = 32174, z = 10}
		}
	},
	-- Troll Sabotage Quest
	[50365] = {
		itemId = false,
		itemPos = {
			{x = 33234, y = 31748, z = 7},
			{x = 33234, y = 31749, z = 7},
			{x = 33241, y = 31772, z = 8},
			{x = 33231, y = 31765, z = 2},
			{x = 33231, y = 31762, z = 2},
			{x = 33231, y = 31760, z = 2}
		}
	}
}

TileUnique = {
	-- Lions rock quest (gems tile) scripts/actions/other/gems
	[25006] = {
		itemId = 21441,
		itemPos = {x = 33069, y = 32298, z = 9}
	},
	[25007] = {
		itemId = 21442,
		itemPos = {x = 33069, y = 32302, z = 9}
	},
	[25008] = {
		itemId = 21440,
		itemPos = {x = 33077, y = 32302, z = 9}
	},
	[25009] = {
		itemId = 21437,
		itemPos = {x = 33077, y = 32298, z = 9}
	},
	[25010] = {
		itemId = 431,
		itemPos = {x = 32225, y = 32268, z = 9}
	},
	-- The paradox tower quest
	[25011] = {
		itemId = 354,
		itemPos = {x = 32497, y = 31889, z = 7}
	},
	[25012] = {
		itemId = 10145,
		itemPos = {x = 32566, y = 31957, z = 1}
	},
	[25013] = {
		itemId = 431,
		itemPos = {x = 32481, y = 31905, z = 7}
	},
	[25014] = {
		itemId = 353,
		itemPos = {x = 32478, y = 31908, z = 7}
	},
	[25015] = {
		itemId = 353,
		itemPos = {x = 32479, y = 31908, z = 7}
	},
	[25016] = {
		itemId = 2772,
		itemPos = {x = 32479, y = 31905, z = 6}
	},
	[25017] = {
		itemId = 431,
		itemPos = {x = 32476, y = 31900, z = 5}
	},
	-- Explorer Society Astral Portals
	-- Path: data\scripts\actions\quests\explorer_society\stone.lua
	-- Path: data\scripts\movements\quests\explorer_society\carvingteleport_port_hope.lua
	-- Path: data\scripts\movements\quests\explorer_society\carving_teleport_liberty_bay.lua
	-- Port Hope
	[25018] = {
		itemId = 599,
		itemPos = {x = 32665, y = 32736, z = 6}
	},
	-- Northport
	[25019] = {
		itemId = 599,
		itemPos = {x = 32497, y = 31622, z = 6}
	},
	-- Liberty Bay
	[25020] = {
		itemId = 599,
		itemPos = {x = 32358, y = 32807, z = 6}
	},
	-- Svarground
	[25021] = {
		itemId = 599,
		itemPos = {x = 32321, y = 31137, z = 6}
	},
	-- The Rookie Guard Quest - Mission 05: Web of Terror
	-- Path: data\scripts\actions\quests\the_rookie_guard\mission05_web_terror.lua
	-- Spider lair entrance hole
	[25022] = {
		itemId = 12728,
		itemPos = {x = 32051, y = 32110, z = 7}
	},
	-- Spider queen chamber hole
	[25023] = {
		itemId = 12728,
		itemPos = {x = 32018, y = 32098, z = 11}
	},
	-- The Rookie Guard Quest - Mission 06: Run Like a Wolf
	-- Path: data\scripts\actions\quests\the_rookie_guard\mission06_run_like_wolf.lua
	-- War wolf den entrance hole
	[25024] = {
		itemId = 12728,
		itemPos = {x = 32138, y = 32132, z = 7}
	},
	-- War wolf den fall tile
	[25025] = {
		itemId = 353,
		itemPos = {x = 32138, y = 32132, z = 8}
	},
	-- War wolf den last floor fall tile
	[25026] = {
		itemId = 354,
		itemPos = {x = 32106, y = 32130, z = 11}
	},
	-- War wolf den last floor ramp tile
	[25027] = {
		itemId = 7542,
		itemPos = {x = 32147, y = 32125, z = 11}
	},
	-- The Rookie Guard Quest - Mission 09: Rock 'n Troll
	-- Path: data\scripts\actions\quests\the_rookie_guard\mission09_rock_troll.lua
	-- Troll caves dug tunnel hole
	[25028] = {
		itemId = 12728,
		itemPos = {x = 32059, y = 32135, z = 9}
	},
	-- Remove/create item on stepIn
	-- Reserved uniques range from 29001/30000

	-- Ornamented shield quest
	[29001] = {
		itemId = 353,
		itemPos = {x = 32770, y = 32282, z = 10},
		targetPos = {x = 32771, y = 32297, z = 10},
		targetItem = 389
	},
	-- Draconia quest
	[29002] = {
		itemId = 431,
		itemPos = {x = 32810, y = 31595, z = 5},
		targetPos = {x = 32796, y = 31594, z = 5},
		targetItem = 1270
	},
	[29003] = {
		itemId = 431,
		itemPos = {x = 32794, y = 31595, z = 5},
		targetPos = {x = 32796, y = 31576, z = 5},
		targetItem = 1270
	}
}
